using System;
using Server;
using Server.Network;
using System.Collections;
using Server.Items;
using Server.Spells;

namespace Server.Mobiles
{
	public class WispNecromancer : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }

		[Constructable]
		public WispNecromancer(): base(AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			SpeechHue = Utility.RandomDyedHue();
			Hue = Utility.RandomSkinHue();

			Utility.AssignRandomHair(this);
			if (this.Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
				Utility.AssignRandomFacialHair(this, HairHue);
			}

			Title = "the Necromancer";

			SetStr(516, 605);
			SetDex(106, 115);
			SetInt(300, 305);

			SetHits(1500, 2000);
			SetMana(2500);

			SetDamage(10, 25);

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 50, 70);
			SetResistance(ResistanceType.Cold, 60, 70);
			SetResistance(ResistanceType.Poison, 50, 60);
			SetResistance(ResistanceType.Energy, 60, 70);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 90.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 95.1);
			SetSkill(SkillName.Tactics, 100.0);
			SetSkill(SkillName.Wrestling, 70.1, 150.0);
			SetSkill(SkillName.Swords, 120.1, 130.0);
			SetSkill(SkillName.Anatomy, 100.0);

			VirtualArmor = 36;
			Fame = 8000;
			Karma = -10000;

			int Barva = Utility.RandomNeutralHue();
			BoneChest chest = new BoneChest();
			chest.Hue = Barva;
			AddItem(chest);
			BoneArms arms = new BoneArms();
			arms.Hue = Barva;
			AddItem(arms);
			BoneGloves gloves = new BoneGloves();
			gloves.Hue = Barva;
			AddItem(gloves);
			BoneLegs legs = new BoneLegs();
			legs.Hue = Barva;
			AddItem(legs);
			BoneHelm helm = new BoneHelm();
			helm.Hue = Barva;
			AddItem(helm);

			Necklace necklace = new Necklace();
			necklace.Hue = 2552;
			necklace.Movable = false;
			AddItem(necklace);

			switch (Utility.Random(3))
			{
				case 0:
				{
					Item wand = new MagicArrowWand();
					wand.Hue = 2552;
					wand.Movable = false;
					AddItem(wand);
				}

				break;
				case 1:
				{
					Item book = new NecromancerSpellbook((UInt64)0xFFFF);
					book.Hue = 2552;
					book.Movable = false;
					AddItem(book);
				}

				break;
				case 2:
				{
					Item staff = new BlackStaff();
					staff.Hue = 2552;
					staff.Movable = false;
					AddItem(staff);
				}

				break;
			}

			Cloak cloak = new Cloak();
			cloak.Hue = 2552;
			cloak.Movable = false;
			AddItem(cloak);

			Kilt kilt = new Kilt();
			kilt.Hue = 2552;
			kilt.Movable = false;
			AddItem(kilt);

			Sandals sandals = new Sandals();
			sandals.Hue = 2552;
			sandals.Movable = false;
			AddItem(sandals);

			PackNecroScroll(Utility.RandomMinMax(2, 6));
			PackNecroReg(1, 15);
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override int TreasureMapLevel { get { return 4; } }
		public override bool CanRummageCorpses { get { return false; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return false; } } //utika pri malem poctu hp

		public WispNecromancer(Serial serial) : base(serial)
		{
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			if (typ == 2)
				amount = 0;

			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (Utility.RandomDouble() < 0.1)
				Summon(from);

			if (Utility.RandomDouble() < 0.1)
				Utilitky.CorpseExplosion(from, this);
		}

		public void Summon(Mobile from)
		{
			Map map = this.Map;

			if (map == null || from == null)
				return;

			Mobile targ = null;

			if (from is PlayerMobile && from.Map == map)
				targ = from;

			BaseCreature summon = (Utility.RandomBool()) ? (BaseCreature) new MadSquirrel(targ, 1.0) : (BaseCreature) new Zombie();

			if (summon == null)
				return;

			bool validLocation = false;
			Point3D loc = this.Location;

			for (int j = 0; !validLocation && j < 10; ++j)
			{
				int x = X + Utility.Random(3) - 1;
				int y = Y + Utility.Random(3) - 1;
				int z = map.GetAverageZ(x, y);

				if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
					loc = new Point3D(x, y, Z);
				else if (validLocation = map.CanFit(x, y, z, 16, false, false))
					loc = new Point3D(x, y, z);
			}

			summon.Name = "a flesh golem";
			summon.Body = 304;
			summon.BaseSoundID = 684;
			summon.Hue = 0;

			if (summon is Zombie)
			{
				summon.Combatant = from;
				summon.IsParagon = true;
				summon.SetHits(700);
				summon.SetDamage(17, 22);
				summon.SetSkill(SkillName.Tactics, 100.1, 120.0);
				summon.SetSkill(SkillName.Wrestling, 90.1, 120.0);

				TimeSpan duration = TimeSpan.FromSeconds(120.0);
				new UnsummonTimer(this, summon, duration).Start();
				summon.SummonEnd = DateTime.Now + duration;
			}

			summon.MoveToWorld(loc, map);
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Miscellaneous);
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}